function UxWebViewSendHttpRequestWithFileFunction(method, url, fileName, base64Data, callback) {
    // Convert base64Data into byteArrays
    var sliceSize = 1024;
    var byteCharacters = atob(base64Data);
    var bytesLength = byteCharacters.length;
    var slicesCount = Math.ceil(bytesLength / sliceSize);
    var byteArrays = new Array(slicesCount);
    for (var sliceIndex = 0; sliceIndex < slicesCount; ++sliceIndex) {
        var begin = sliceIndex * sliceSize;
        var end = Math.min(begin + sliceSize, bytesLength);

        var bytes = new Array(end - begin);
        for (var offset = begin, i = 0; offset < end; ++i, ++offset) {
            bytes[i] = byteCharacters[offset].charCodeAt(0);
        }
        byteArrays[sliceIndex] = new Uint8Array(bytes);
    }

    // Create formData
    var formData = new FormData();
    formData.append("file", new Blob(byteArrays), fileName);

    // Send formData
    var request = new XMLHttpRequest();
    request.open(method, url);
    request.onload = function () {
        callback.onLoad(request.status, request.responseText);
    };
    request.send(formData);
}
